// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Hashes.
 */
public class Hashes implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Crc32Hash.
     * The CRC32 value of the file in little endian (if available). Read-only.
     */
    @SerializedName("crc32Hash")
    @Expose
    public String crc32Hash;

    /**
     * The Quick Xor Hash.
     * A proprietary hash of the file that can be used to determine if the contents of the file have changed (if available). Read-only.
     */
    @SerializedName("quickXorHash")
    @Expose
    public String quickXorHash;

    /**
     * The Sha1Hash.
     * SHA1 hash for the contents of the file (if available). Read-only.
     */
    @SerializedName("sha1Hash")
    @Expose
    public String sha1Hash;

    /**
     * The Sha256Hash.
     * SHA256 hash for the contents of the file (if available). Read-only.
     */
    @SerializedName("sha256Hash")
    @Expose
    public String sha256Hash;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
