// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.generated.IosNotificationAlertType;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.*;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Ios Notification Settings.
 */
public class IosNotificationSettings implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Bundle ID.
     * Bundle id of app to which to apply these notification settings.
     */
    @SerializedName("bundleID")
    @Expose
    public String bundleID;

    /**
     * The App Name.
     * Application name to be associated with the bundleID.
     */
    @SerializedName("appName")
    @Expose
    public String appName;

    /**
     * The Publisher.
     * Publisher to be associated with the bundleID.
     */
    @SerializedName("publisher")
    @Expose
    public String publisher;

    /**
     * The Enabled.
     * Indicates whether notifications are allowed for this app.
     */
    @SerializedName("enabled")
    @Expose
    public Boolean enabled;

    /**
     * The Show In Notification Center.
     * Indicates whether notifications can be shown in notification center.
     */
    @SerializedName("showInNotificationCenter")
    @Expose
    public Boolean showInNotificationCenter;

    /**
     * The Show On Lock Screen.
     * Indicates whether notifications can be shown on the lock screen.
     */
    @SerializedName("showOnLockScreen")
    @Expose
    public Boolean showOnLockScreen;

    /**
     * The Alert Type.
     * Indicates the type of alert for notifications for this app. Possible values are: deviceDefault, banner, modal, none.
     */
    @SerializedName("alertType")
    @Expose
    public IosNotificationAlertType alertType;

    /**
     * The Badges Enabled.
     * Indicates whether badges are allowed for this app.
     */
    @SerializedName("badgesEnabled")
    @Expose
    public Boolean badgesEnabled;

    /**
     * The Sounds Enabled.
     * Indicates whether sounds are allowed for this app.
     */
    @SerializedName("soundsEnabled")
    @Expose
    public Boolean soundsEnabled;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
