// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Calendar Allowed Calendar Sharing Roles Collection Request Builder.
 */
public class CalendarAllowedCalendarSharingRolesCollectionRequestBuilder extends BaseFunctionRequestBuilder implements ICalendarAllowedCalendarSharingRolesCollectionRequestBuilder {

    /**
     * The request builder for this collection of Calendar
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param user the user
     */
    public CalendarAllowedCalendarSharingRolesCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final String user) {
        super(requestUrl, client, requestOptions);
     	 if(user!=null){
			functionOptions.add(new FunctionOption("user", user));
		}
      }

    public ICalendarAllowedCalendarSharingRolesCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public ICalendarAllowedCalendarSharingRolesCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        CalendarAllowedCalendarSharingRolesCollectionRequest request = new CalendarAllowedCalendarSharingRolesCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

      for (FunctionOption option : functionOptions) {
            request.addFunctionOption(option);
      }

        return request;
    }
}
