// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.CallUpdateRecordingStatusBody;
import com.microsoft.graph.models.extensions.UpdateRecordingStatusOperation;
import com.microsoft.graph.requests.extensions.ICallUpdateRecordingStatusRequest;
import com.microsoft.graph.requests.extensions.CallUpdateRecordingStatusRequest;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Call Update Recording Status Request.
 */
public class CallUpdateRecordingStatusRequest extends BaseRequest implements ICallUpdateRecordingStatusRequest {
    protected final CallUpdateRecordingStatusBody body;

    /**
     * The request for this CallUpdateRecordingStatus
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public CallUpdateRecordingStatusRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, UpdateRecordingStatusOperation.class);
        body = new CallUpdateRecordingStatusBody();
    }

    public void post(final ICallback<UpdateRecordingStatusOperation> callback) {
        send(HttpMethod.POST, callback, body);
    }

    public UpdateRecordingStatusOperation post() throws ClientException {
        return send(HttpMethod.POST, body);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ICallUpdateRecordingStatusRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (CallUpdateRecordingStatusRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public ICallUpdateRecordingStatusRequest top(final int value) {
        getQueryOptions().add(new QueryOption("$top", value+""));
        return (CallUpdateRecordingStatusRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ICallUpdateRecordingStatusRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (CallUpdateRecordingStatusRequest)this;
    }

}
