// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Claims Mapping Policy Reference Request.
 */
public class ClaimsMappingPolicyReferenceRequest extends BaseRequest implements IClaimsMappingPolicyReferenceRequest {

    /**
     * The request for the ClaimsMappingPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ClaimsMappingPolicyReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ClaimsMappingPolicy.class);
    }

    public void delete(final ICallback<ClaimsMappingPolicy> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public ClaimsMappingPolicy delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IClaimsMappingPolicyReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (ClaimsMappingPolicyReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IClaimsMappingPolicyReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (ClaimsMappingPolicyReferenceRequest)this;
    }
    /**
     * Puts the ClaimsMappingPolicy
     *
     * @param srcClaimsMappingPolicy the ClaimsMappingPolicy reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(ClaimsMappingPolicy srcClaimsMappingPolicy, final ICallback<ClaimsMappingPolicy> callback) {
        send(HttpMethod.PUT, callback, srcClaimsMappingPolicy);
    }

    /**
     * Puts the ClaimsMappingPolicy
     *
     * @param srcClaimsMappingPolicy the ClaimsMappingPolicy reference to PUT
     * @return the ClaimsMappingPolicy
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public ClaimsMappingPolicy put(ClaimsMappingPolicy srcClaimsMappingPolicy) throws ClientException {
        return send(HttpMethod.PUT, srcClaimsMappingPolicy);
    }
}
