// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Policy Collection Request.
 */
public class ConditionalAccessPolicyCollectionRequest extends BaseCollectionRequest<ConditionalAccessPolicyCollectionResponse, IConditionalAccessPolicyCollectionPage> implements IConditionalAccessPolicyCollectionRequest {

    /**
     * The request builder for this collection of ConditionalAccessPolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConditionalAccessPolicyCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ConditionalAccessPolicyCollectionResponse.class, IConditionalAccessPolicyCollectionPage.class);
    }

    public void get(final ICallback<IConditionalAccessPolicyCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IConditionalAccessPolicyCollectionPage get() throws ClientException {
        final ConditionalAccessPolicyCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final ConditionalAccessPolicy newConditionalAccessPolicy, final ICallback<ConditionalAccessPolicy> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ConditionalAccessPolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newConditionalAccessPolicy, callback);
    }

    public ConditionalAccessPolicy post(final ConditionalAccessPolicy newConditionalAccessPolicy) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ConditionalAccessPolicyRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newConditionalAccessPolicy);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IConditionalAccessPolicyCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ConditionalAccessPolicyCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IConditionalAccessPolicyCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ConditionalAccessPolicyCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IConditionalAccessPolicyCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ConditionalAccessPolicyCollectionRequest)this;
    }

    public IConditionalAccessPolicyCollectionPage buildFromResponse(final ConditionalAccessPolicyCollectionResponse response) {
        final IConditionalAccessPolicyCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ConditionalAccessPolicyCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ConditionalAccessPolicyCollectionPage page = new ConditionalAccessPolicyCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
