// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IConditionalAccessRootRequest;
import com.microsoft.graph.requests.extensions.ConditionalAccessRootRequest;
import com.microsoft.graph.requests.extensions.IConditionalAccessPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IConditionalAccessPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.ConditionalAccessPolicyRequestBuilder;
import com.microsoft.graph.requests.extensions.INamedLocationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.NamedLocationCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.INamedLocationRequestBuilder;
import com.microsoft.graph.requests.extensions.NamedLocationRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Conditional Access Root Request Builder.
 */
public class ConditionalAccessRootRequestBuilder extends BaseRequestBuilder implements IConditionalAccessRootRequestBuilder {

    /**
     * The request builder for the ConditionalAccessRoot
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ConditionalAccessRootRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IConditionalAccessRootRequest instance
     */
    public IConditionalAccessRootRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IConditionalAccessRootRequest instance
     */
    public IConditionalAccessRootRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ConditionalAccessRootRequest(getRequestUrl(), getClient(), requestOptions);
    }


    public IConditionalAccessPolicyCollectionRequestBuilder policies() {
        return new ConditionalAccessPolicyCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("policies"), getClient(), null);
    }

    public IConditionalAccessPolicyRequestBuilder policies(final String id) {
        return new ConditionalAccessPolicyRequestBuilder(getRequestUrlWithAdditionalSegment("policies") + "/" + id, getClient(), null);
    }
    public INamedLocationCollectionRequestBuilder namedLocations() {
        return new NamedLocationCollectionRequestBuilder(getRequestUrlWithAdditionalSegment("namedLocations"), getClient(), null);
    }

    public INamedLocationRequestBuilder namedLocations(final String id) {
        return new NamedLocationRequestBuilder(getRequestUrlWithAdditionalSegment("namedLocations") + "/" + id, getClient(), null);
    }
}

