// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Management Get Effective Permissions Collection Request.
 */
public class DeviceManagementGetEffectivePermissionsCollectionRequest extends BaseCollectionRequest<DeviceManagementGetEffectivePermissionsCollectionResponse, IDeviceManagementGetEffectivePermissionsCollectionPage> implements IDeviceManagementGetEffectivePermissionsCollectionRequest {


    /**
     * The request for this DeviceManagementGetEffectivePermissions
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceManagementGetEffectivePermissionsCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceManagementGetEffectivePermissionsCollectionResponse.class, IDeviceManagementGetEffectivePermissionsCollectionPage.class);
    }


    public void get(final ICallback<IDeviceManagementGetEffectivePermissionsCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IDeviceManagementGetEffectivePermissionsCollectionPage get() throws ClientException {
        final DeviceManagementGetEffectivePermissionsCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IDeviceManagementGetEffectivePermissionsCollectionPage buildFromResponse(final DeviceManagementGetEffectivePermissionsCollectionResponse response) {
        final IDeviceManagementGetEffectivePermissionsCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new DeviceManagementGetEffectivePermissionsCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null, /* scope */ null);
        } else {
            builder = null;
        }
        final IDeviceManagementGetEffectivePermissionsCollectionPage page = new DeviceManagementGetEffectivePermissionsCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IDeviceManagementGetEffectivePermissionsCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (IDeviceManagementGetEffectivePermissionsCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IDeviceManagementGetEffectivePermissionsCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value+""));
        return (IDeviceManagementGetEffectivePermissionsCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IDeviceManagementGetEffectivePermissionsCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (IDeviceManagementGetEffectivePermissionsCollectionRequest)this;
    }

}
