// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Get Available Extension Properties Collection Request Builder.
 */
public class DirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder extends BaseActionRequestBuilder implements IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder {

    /**
     * The request builder for this collection of DirectoryObject
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param isSyncedFromOnPremises the isSyncedFromOnPremises
     */
    public DirectoryObjectGetAvailableExtensionPropertiesCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final Boolean isSyncedFromOnPremises) {
        super(requestUrl, client, requestOptions);
  	 if(isSyncedFromOnPremises!=null){
			bodyParams.put("isSyncedFromOnPremises", isSyncedFromOnPremises);
		}
      }

    public IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IDirectoryObjectGetAvailableExtensionPropertiesCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        DirectoryObjectGetAvailableExtensionPropertiesCollectionRequest request = new DirectoryObjectGetAvailableExtensionPropertiesCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("isSyncedFromOnPremises")) {
            request.body.isSyncedFromOnPremises = getParameter("isSyncedFromOnPremises");
        }
  
        return request;
    }
}
