// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Invite Collection Request Builder.
 */
public class DriveItemInviteCollectionRequestBuilder extends BaseActionRequestBuilder implements IDriveItemInviteCollectionRequestBuilder {

    /**
     * The request builder for this collection of DriveItem
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param requireSignIn the requireSignIn
     * @param roles the roles
     * @param sendInvitation the sendInvitation
     * @param message the message
     * @param recipients the recipients
     * @param expirationDateTime the expirationDateTime
     * @param password the password
     */
    public DriveItemInviteCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final Boolean requireSignIn, final java.util.List<String> roles, final Boolean sendInvitation, final String message, final java.util.List<DriveRecipient> recipients, final String expirationDateTime, final String password) {
        super(requestUrl, client, requestOptions);
  	 if(requireSignIn!=null){
			bodyParams.put("requireSignIn", requireSignIn);
		}
    	 if(roles!=null){
			bodyParams.put("roles", roles);
		}
    	 if(sendInvitation!=null){
			bodyParams.put("sendInvitation", sendInvitation);
		}
    	 if(message!=null){
			bodyParams.put("message", message);
		}
    	 if(recipients!=null){
			bodyParams.put("recipients", recipients);
		}
    	 if(expirationDateTime!=null){
			bodyParams.put("expirationDateTime", expirationDateTime);
		}
    	 if(password!=null){
			bodyParams.put("password", password);
		}
      }

    public IDriveItemInviteCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IDriveItemInviteCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        DriveItemInviteCollectionRequest request = new DriveItemInviteCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("requireSignIn")) {
            request.body.requireSignIn = getParameter("requireSignIn");
        }
        if (hasParameter("roles")) {
            request.body.roles = getParameter("roles");
        }
        if (hasParameter("sendInvitation")) {
            request.body.sendInvitation = getParameter("sendInvitation");
        }
        if (hasParameter("message")) {
            request.body.message = getParameter("message");
        }
        if (hasParameter("recipients")) {
            request.body.recipients = getParameter("recipients");
        }
        if (hasParameter("expirationDateTime")) {
            request.body.expirationDateTime = getParameter("expirationDateTime");
        }
        if (hasParameter("password")) {
            request.body.password = getParameter("password");
        }
  
        return request;
    }
}
