// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDriveItemUnfollowRequest;
import com.microsoft.graph.requests.extensions.DriveItemUnfollowRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.FunctionOption;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Unfollow Request Builder.
 */
public class DriveItemUnfollowRequestBuilder extends BaseActionRequestBuilder implements IDriveItemUnfollowRequestBuilder {

    /**
     * The request builder for this DriveItemUnfollow
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DriveItemUnfollowRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IDriveItemUnfollowRequest
     *
     * @return the IDriveItemUnfollowRequest instance
     */
    public IDriveItemUnfollowRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IDriveItemUnfollowRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IDriveItemUnfollowRequest instance
     */
    public IDriveItemUnfollowRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        DriveItemUnfollowRequest request = new DriveItemUnfollowRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
