// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ComplianceManagementPartner;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Compliance Management Partner Request.
 */
public interface IComplianceManagementPartnerRequest extends IHttpRequest {

    /**
     * Gets the ComplianceManagementPartner from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ComplianceManagementPartner> callback);

    /**
     * Gets the ComplianceManagementPartner from the service
     *
     * @return the ComplianceManagementPartner from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ComplianceManagementPartner get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ComplianceManagementPartner> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ComplianceManagementPartner with a source
     *
     * @param sourceComplianceManagementPartner the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ComplianceManagementPartner sourceComplianceManagementPartner, final ICallback<ComplianceManagementPartner> callback);

    /**
     * Patches this ComplianceManagementPartner with a source
     *
     * @param sourceComplianceManagementPartner the source object with updates
     * @return the updated ComplianceManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ComplianceManagementPartner patch(final ComplianceManagementPartner sourceComplianceManagementPartner) throws ClientException;

    /**
     * Posts a ComplianceManagementPartner with a new object
     *
     * @param newComplianceManagementPartner the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ComplianceManagementPartner newComplianceManagementPartner, final ICallback<ComplianceManagementPartner> callback);

    /**
     * Posts a ComplianceManagementPartner with a new object
     *
     * @param newComplianceManagementPartner the new object to create
     * @return the created ComplianceManagementPartner
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ComplianceManagementPartner post(final ComplianceManagementPartner newComplianceManagementPartner) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IComplianceManagementPartnerRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IComplianceManagementPartnerRequest expand(final String value);

}

