// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IDriveRequest;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IListRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveItemRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveRecentCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSearchCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IDriveSharedWithMeCollectionRequestBuilder;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Drive Request Builder.
 */
public interface IDriveRequestBuilder extends IRequestBuilder {
    /**
     * Creates the request
     *
     * @return the IDriveRequest instance
     */
    IDriveRequest buildRequest();

    /**
     * Creates the request with specific options instead of the existing options
     *
     * @param requestOptions the options for this request
     * @return the IDriveRequest instance
     */
    IDriveRequest buildRequest(final java.util.List<? extends Option> requestOptions);


    IDriveItemCollectionRequestBuilder following();

    IDriveItemRequestBuilder following(final String id);

    IDriveItemCollectionRequestBuilder items();

    IDriveItemRequestBuilder items(final String id);

    /**
     * Gets the request builder for List
     *
     * @return the IListRequestBuilder instance
     */
    IListRequestBuilder list();

    /**
     * Gets the request builder for DriveItem
     *
     * @return the IDriveItemRequestBuilder instance
     */
    IDriveItemRequestBuilder root();

    IDriveItemCollectionRequestBuilder special();

    IDriveItemRequestBuilder special(final String id);

    IDriveRecentCollectionRequestBuilder recent();

    IDriveSearchCollectionRequestBuilder search(final String q);

    IDriveSharedWithMeCollectionRequestBuilder sharedWithMe();

}
