// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ListItemVersion;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the List Item Version Request.
 */
public interface IListItemVersionRequest extends IHttpRequest {

    /**
     * Gets the ListItemVersion from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ListItemVersion> callback);

    /**
     * Gets the ListItemVersion from the service
     *
     * @return the ListItemVersion from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItemVersion get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ListItemVersion> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ListItemVersion with a source
     *
     * @param sourceListItemVersion the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ListItemVersion sourceListItemVersion, final ICallback<ListItemVersion> callback);

    /**
     * Patches this ListItemVersion with a source
     *
     * @param sourceListItemVersion the source object with updates
     * @return the updated ListItemVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItemVersion patch(final ListItemVersion sourceListItemVersion) throws ClientException;

    /**
     * Posts a ListItemVersion with a new object
     *
     * @param newListItemVersion the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ListItemVersion newListItemVersion, final ICallback<ListItemVersion> callback);

    /**
     * Posts a ListItemVersion with a new object
     *
     * @param newListItemVersion the new object to create
     * @return the created ListItemVersion
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ListItemVersion post(final ListItemVersion newListItemVersion) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IListItemVersionRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IListItemVersionRequest expand(final String value);

}

