// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the OAuth2Permission Grant With Reference Request.
 */
public interface IOAuth2PermissionGrantWithReferenceRequest extends IHttpRequest {

    void post(final OAuth2PermissionGrant newOAuth2PermissionGrant, final IJsonBackedObject payload, final ICallback<OAuth2PermissionGrant> callback);

    OAuth2PermissionGrant post(final OAuth2PermissionGrant newOAuth2PermissionGrant, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<OAuth2PermissionGrant> callback);

    OAuth2PermissionGrant get() throws ClientException;

	void delete(final ICallback<OAuth2PermissionGrant> callback);

	void delete() throws ClientException;

	void patch(final OAuth2PermissionGrant sourceOAuth2PermissionGrant, final ICallback<OAuth2PermissionGrant> callback);

	OAuth2PermissionGrant patch(final OAuth2PermissionGrant sourceOAuth2PermissionGrant) throws ClientException;

    IOAuth2PermissionGrantWithReferenceRequest select(final String value);

    IOAuth2PermissionGrantWithReferenceRequest expand(final String value);

}
