// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Teams Template With Reference Request.
 */
public interface ITeamsTemplateWithReferenceRequest extends IHttpRequest {

    void post(final TeamsTemplate newTeamsTemplate, final IJsonBackedObject payload, final ICallback<TeamsTemplate> callback);

    TeamsTemplate post(final TeamsTemplate newTeamsTemplate, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<TeamsTemplate> callback);

    TeamsTemplate get() throws ClientException;

	void delete(final ICallback<TeamsTemplate> callback);

	void delete() throws ClientException;

	void patch(final TeamsTemplate sourceTeamsTemplate, final ICallback<TeamsTemplate> callback);

	TeamsTemplate patch(final TeamsTemplate sourceTeamsTemplate) throws ClientException;

    ITeamsTemplateWithReferenceRequest select(final String value);

    ITeamsTemplateWithReferenceRequest expand(final String value);

}
