// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkforceIntegration;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workforce Integration Request.
 */
public interface IWorkforceIntegrationRequest extends IHttpRequest {

    /**
     * Gets the WorkforceIntegration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkforceIntegration> callback);

    /**
     * Gets the WorkforceIntegration from the service
     *
     * @return the WorkforceIntegration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkforceIntegration get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkforceIntegration> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkforceIntegration with a source
     *
     * @param sourceWorkforceIntegration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkforceIntegration sourceWorkforceIntegration, final ICallback<WorkforceIntegration> callback);

    /**
     * Patches this WorkforceIntegration with a source
     *
     * @param sourceWorkforceIntegration the source object with updates
     * @return the updated WorkforceIntegration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkforceIntegration patch(final WorkforceIntegration sourceWorkforceIntegration) throws ClientException;

    /**
     * Posts a WorkforceIntegration with a new object
     *
     * @param newWorkforceIntegration the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkforceIntegration newWorkforceIntegration, final ICallback<WorkforceIntegration> callback);

    /**
     * Posts a WorkforceIntegration with a new object
     *
     * @param newWorkforceIntegration the new object to create
     * @return the created WorkforceIntegration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkforceIntegration post(final WorkforceIntegration newWorkforceIntegration) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkforceIntegrationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkforceIntegrationRequest expand(final String value);

}

