// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the OAuth2Permission Grant Reference Request.
 */
public class OAuth2PermissionGrantReferenceRequest extends BaseRequest implements IOAuth2PermissionGrantReferenceRequest {

    /**
     * The request for the OAuth2PermissionGrant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OAuth2PermissionGrantReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, OAuth2PermissionGrant.class);
    }

    public void delete(final ICallback<OAuth2PermissionGrant> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public OAuth2PermissionGrant delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IOAuth2PermissionGrantReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (OAuth2PermissionGrantReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IOAuth2PermissionGrantReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (OAuth2PermissionGrantReferenceRequest)this;
    }
    /**
     * Puts the OAuth2PermissionGrant
     *
     * @param srcOAuth2PermissionGrant the OAuth2PermissionGrant reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(OAuth2PermissionGrant srcOAuth2PermissionGrant, final ICallback<OAuth2PermissionGrant> callback) {
        send(HttpMethod.PUT, callback, srcOAuth2PermissionGrant);
    }

    /**
     * Puts the OAuth2PermissionGrant
     *
     * @param srcOAuth2PermissionGrant the OAuth2PermissionGrant reference to PUT
     * @return the OAuth2PermissionGrant
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public OAuth2PermissionGrant put(OAuth2PermissionGrant srcOAuth2PermissionGrant) throws ClientException {
        return send(HttpMethod.PUT, srcOAuth2PermissionGrant);
    }
}
