// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the OAuth2Permission Grant With Reference Request Builder.
 */
public class OAuth2PermissionGrantWithReferenceRequestBuilder extends BaseRequestBuilder implements IOAuth2PermissionGrantWithReferenceRequestBuilder {

    /**
     * The request builder for the OAuth2PermissionGrant
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public OAuth2PermissionGrantWithReferenceRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IOAuth2PermissionGrantWithReferenceRequest instance
     */
    public IOAuth2PermissionGrantWithReferenceRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific options instead of the existing options
	 *
     * @param requestOptions the options for this request
     * @return the IOAuth2PermissionGrantWithReferenceRequest instance
     */
    public IOAuth2PermissionGrantWithReferenceRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new OAuth2PermissionGrantWithReferenceRequest(getRequestUrl(), getClient(), requestOptions);
    }

    public IOAuth2PermissionGrantReferenceRequestBuilder reference(){
        return new OAuth2PermissionGrantReferenceRequestBuilder(getRequestUrl() + "/$ref", getClient(), getOptions());
    }

}
