// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IScheduleChangeRequestRequest;
import com.microsoft.graph.requests.extensions.ScheduleChangeRequestRequest;
import com.microsoft.graph.requests.extensions.IScheduleChangeRequestApproveRequestBuilder;
import com.microsoft.graph.requests.extensions.ScheduleChangeRequestApproveRequestBuilder;
import com.microsoft.graph.requests.extensions.IScheduleChangeRequestDeclineRequestBuilder;
import com.microsoft.graph.requests.extensions.ScheduleChangeRequestDeclineRequestBuilder;

import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequestBuilder;
import com.microsoft.graph.options.Option;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Schedule Change Request Request Builder.
 */
public class ScheduleChangeRequestRequestBuilder extends BaseRequestBuilder implements IScheduleChangeRequestRequestBuilder {

    /**
     * The request builder for the ScheduleChangeRequest
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ScheduleChangeRequestRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the request
     *
     * @return the IScheduleChangeRequestRequest instance
     */
    public IScheduleChangeRequestRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the request with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for this request
     * @return the IScheduleChangeRequestRequest instance
     */
    public IScheduleChangeRequestRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        return new ScheduleChangeRequestRequest(getRequestUrl(), getClient(), requestOptions);
    }



    public IScheduleChangeRequestApproveRequestBuilder approve(final String message) {
        return new ScheduleChangeRequestApproveRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.approve"), getClient(), null, message);
    }

    public IScheduleChangeRequestDeclineRequestBuilder decline(final String message) {
        return new ScheduleChangeRequestDeclineRequestBuilder(getRequestUrlWithAdditionalSegment("microsoft.graph.decline"), getClient(), null, message);
    }
}

