// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Shift Collection Request.
 */
public class ShiftCollectionRequest extends BaseCollectionRequest<ShiftCollectionResponse, IShiftCollectionPage> implements IShiftCollectionRequest {

    /**
     * The request builder for this collection of Shift
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public ShiftCollectionRequest(final String requestUrl, IBaseClient client, final java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, ShiftCollectionResponse.class, IShiftCollectionPage.class);
    }

    public void get(final ICallback<IShiftCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IShiftCollectionPage get() throws ClientException {
        final ShiftCollectionResponse response = send();
        return buildFromResponse(response);
    }

    public void post(final Shift newShift, final ICallback<Shift> callback) {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        new ShiftRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newShift, callback);
    }

    public Shift post(final Shift newShift) throws ClientException {
        final String requestUrl = getBaseRequest().getRequestUrl().toString();
        return new ShiftRequestBuilder(requestUrl, getBaseRequest().getClient(), /* Options */ null)
            .buildRequest(getBaseRequest().getOptions())
            .post(newShift);
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IShiftCollectionRequest expand(final String value) {
        addQueryOption(new QueryOption("$expand", value));
        return (ShiftCollectionRequest)this;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IShiftCollectionRequest select(final String value) {
        addQueryOption(new QueryOption("$select", value));
        return (ShiftCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IShiftCollectionRequest top(final int value) {
        addQueryOption(new QueryOption("$top", value + ""));
        return (ShiftCollectionRequest)this;
    }

    public IShiftCollectionPage buildFromResponse(final ShiftCollectionResponse response) {
        final IShiftCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new ShiftCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final ShiftCollectionPage page = new ShiftCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}
