// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Token Lifetime Policy Reference Request.
 */
public class TokenLifetimePolicyReferenceRequest extends BaseRequest implements ITokenLifetimePolicyReferenceRequest {

    /**
     * The request for the TokenLifetimePolicy
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TokenLifetimePolicyReferenceRequest(String requestUrl, IBaseClient client, java.util.List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, TokenLifetimePolicy.class);
    }

    public void delete(final ICallback<TokenLifetimePolicy> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    public TokenLifetimePolicy delete() throws ClientException {
       return send(HttpMethod.DELETE, null);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public ITokenLifetimePolicyReferenceRequest select(final String value) {
        getQueryOptions().add(new QueryOption("$select", value));
        return (TokenLifetimePolicyReferenceRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public ITokenLifetimePolicyReferenceRequest expand(final String value) {
        getQueryOptions().add(new QueryOption("$expand", value));
        return (TokenLifetimePolicyReferenceRequest)this;
    }
    /**
     * Puts the TokenLifetimePolicy
     *
     * @param srcTokenLifetimePolicy the TokenLifetimePolicy reference to PUT
     * @param callback the callback to be called after success or failure
     */
    public void put(TokenLifetimePolicy srcTokenLifetimePolicy, final ICallback<TokenLifetimePolicy> callback) {
        send(HttpMethod.PUT, callback, srcTokenLifetimePolicy);
    }

    /**
     * Puts the TokenLifetimePolicy
     *
     * @param srcTokenLifetimePolicy the TokenLifetimePolicy reference to PUT
     * @return the TokenLifetimePolicy
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    public TokenLifetimePolicy put(TokenLifetimePolicy srcTokenLifetimePolicy) throws ClientException {
        return send(HttpMethod.PUT, srcTokenLifetimePolicy);
    }
}
