// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.*;
import com.microsoft.graph.core.*;
import com.microsoft.graph.models.extensions.*;
import com.microsoft.graph.models.generated.*;
import com.microsoft.graph.http.*;
import com.microsoft.graph.requests.extensions.*;
import com.microsoft.graph.options.*;
import com.microsoft.graph.serializer.*;

import java.util.Arrays;
import java.util.EnumSet;
// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Translate Exchange Ids Collection Request Builder.
 */
public class UserTranslateExchangeIdsCollectionRequestBuilder extends BaseActionRequestBuilder implements IUserTranslateExchangeIdsCollectionRequestBuilder {

    /**
     * The request builder for this collection of User
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param inputIds the inputIds
     * @param targetIdType the targetIdType
     * @param sourceIdType the sourceIdType
     */
    public UserTranslateExchangeIdsCollectionRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends Option> requestOptions, final java.util.List<String> inputIds, final ExchangeIdFormat targetIdType, final ExchangeIdFormat sourceIdType) {
        super(requestUrl, client, requestOptions);
  	 if(inputIds!=null){
			bodyParams.put("inputIds", inputIds);
		}
    	 if(targetIdType!=null){
			bodyParams.put("targetIdType", targetIdType);
		}
    	 if(sourceIdType!=null){
			bodyParams.put("sourceIdType", sourceIdType);
		}
      }

    public IUserTranslateExchangeIdsCollectionRequest buildRequest() {
        return buildRequest(getOptions());
    }

    public IUserTranslateExchangeIdsCollectionRequest buildRequest(final java.util.List<? extends Option> requestOptions) {
        UserTranslateExchangeIdsCollectionRequest request = new UserTranslateExchangeIdsCollectionRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("inputIds")) {
            request.body.inputIds = getParameter("inputIds");
        }
        if (hasParameter("targetIdType")) {
            request.body.targetIdType = getParameter("targetIdType");
        }
        if (hasParameter("sourceIdType")) {
            request.body.sourceIdType = getParameter("sourceIdType");
        }
  
        return request;
    }
}
