/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.models.extensions;

import com.google.gson.JsonObject;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import com.microsoft.graph.models.extensions.ChatMessageAttachment;
import com.microsoft.graph.models.extensions.ChatMessageHostedContent;
import com.microsoft.graph.models.extensions.ChatMessageMention;
import com.microsoft.graph.models.extensions.ChatMessagePolicyViolation;
import com.microsoft.graph.models.extensions.ChatMessageReaction;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.models.extensions.IdentitySet;
import com.microsoft.graph.models.extensions.ItemBody;
import com.microsoft.graph.models.generated.ChatMessageImportance;
import com.microsoft.graph.models.generated.ChatMessageType;
import com.microsoft.graph.requests.extensions.ChatMessageCollectionPage;
import com.microsoft.graph.requests.extensions.ChatMessageCollectionResponse;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentCollectionPage;
import com.microsoft.graph.requests.extensions.ChatMessageHostedContentCollectionResponse;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.ISerializer;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class ChatMessage
extends Entity
implements IJsonBackedObject {
    @SerializedName(value="replyToId")
    @Expose
    public String replyToId;
    @SerializedName(value="from")
    @Expose
    public IdentitySet from;
    @SerializedName(value="etag")
    @Expose
    public String etag;
    @SerializedName(value="messageType")
    @Expose
    public ChatMessageType messageType;
    @SerializedName(value="createdDateTime")
    @Expose
    public Calendar createdDateTime;
    @SerializedName(value="lastModifiedDateTime")
    @Expose
    public Calendar lastModifiedDateTime;
    @SerializedName(value="deletedDateTime")
    @Expose
    public Calendar deletedDateTime;
    @SerializedName(value="subject")
    @Expose
    public String subject;
    @SerializedName(value="body")
    @Expose
    public ItemBody body;
    @SerializedName(value="summary")
    @Expose
    public String summary;
    @SerializedName(value="attachments")
    @Expose
    public List<ChatMessageAttachment> attachments;
    @SerializedName(value="mentions")
    @Expose
    public List<ChatMessageMention> mentions;
    @SerializedName(value="importance")
    @Expose
    public ChatMessageImportance importance;
    @SerializedName(value="policyViolation")
    @Expose
    public ChatMessagePolicyViolation policyViolation;
    @SerializedName(value="reactions")
    @Expose
    public List<ChatMessageReaction> reactions;
    @SerializedName(value="locale")
    @Expose
    public String locale;
    @SerializedName(value="webUrl")
    @Expose
    public String webUrl;
    public ChatMessageCollectionPage replies;
    public ChatMessageHostedContentCollectionPage hostedContents;
    private JsonObject rawObject;
    private ISerializer serializer;

    @Override
    public JsonObject getRawObject() {
        return this.rawObject;
    }

    @Override
    protected ISerializer getSerializer() {
        return this.serializer;
    }

    @Override
    public void setRawObject(ISerializer serializer, JsonObject json) {
        int i;
        Entity[] array;
        JsonObject[] sourceArray;
        IJsonBackedObject response;
        this.serializer = serializer;
        this.rawObject = json;
        if (json.has("replies")) {
            response = new ChatMessageCollectionResponse();
            if (json.has("replies@odata.nextLink")) {
                response.nextLink = json.get("replies@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("replies").toString(), JsonObject[].class);
            array = new ChatMessage[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ChatMessage.class);
                ((ChatMessage)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            this.replies = new ChatMessageCollectionPage((ChatMessageCollectionResponse)response, null);
        }
        if (json.has("hostedContents")) {
            response = new ChatMessageHostedContentCollectionResponse();
            if (json.has("hostedContents@odata.nextLink")) {
                ((ChatMessageHostedContentCollectionResponse)response).nextLink = json.get("hostedContents@odata.nextLink").getAsString();
            }
            sourceArray = serializer.deserializeObject(json.get("hostedContents").toString(), JsonObject[].class);
            array = new ChatMessageHostedContent[sourceArray.length];
            for (i = 0; i < sourceArray.length; ++i) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), ChatMessageHostedContent.class);
                ((ChatMessageHostedContent)array[i]).setRawObject(serializer, sourceArray[i]);
            }
            ((ChatMessageHostedContentCollectionResponse)response).value = Arrays.asList(array);
            this.hostedContents = new ChatMessageHostedContentCollectionPage((ChatMessageHostedContentCollectionResponse)response, null);
        }
    }
}

