// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.Entity;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Software Update Status Summary.
 */
public class SoftwareUpdateStatusSummary extends Entity implements IJsonBackedObject {


    /**
     * The Compliant Device Count.
     * Number of compliant devices.
     */
    @SerializedName("compliantDeviceCount")
    @Expose
    public Integer compliantDeviceCount;

    /**
     * The Compliant User Count.
     * Number of compliant users.
     */
    @SerializedName("compliantUserCount")
    @Expose
    public Integer compliantUserCount;

    /**
     * The Conflict Device Count.
     * Number of conflict devices.
     */
    @SerializedName("conflictDeviceCount")
    @Expose
    public Integer conflictDeviceCount;

    /**
     * The Conflict User Count.
     * Number of conflict users.
     */
    @SerializedName("conflictUserCount")
    @Expose
    public Integer conflictUserCount;

    /**
     * The Display Name.
     * The name of the policy.
     */
    @SerializedName("displayName")
    @Expose
    public String displayName;

    /**
     * The Error Device Count.
     * Number of devices had error.
     */
    @SerializedName("errorDeviceCount")
    @Expose
    public Integer errorDeviceCount;

    /**
     * The Error User Count.
     * Number of users had error.
     */
    @SerializedName("errorUserCount")
    @Expose
    public Integer errorUserCount;

    /**
     * The Non Compliant Device Count.
     * Number of non compliant devices.
     */
    @SerializedName("nonCompliantDeviceCount")
    @Expose
    public Integer nonCompliantDeviceCount;

    /**
     * The Non Compliant User Count.
     * Number of non compliant users.
     */
    @SerializedName("nonCompliantUserCount")
    @Expose
    public Integer nonCompliantUserCount;

    /**
     * The Not Applicable Device Count.
     * Number of not applicable devices.
     */
    @SerializedName("notApplicableDeviceCount")
    @Expose
    public Integer notApplicableDeviceCount;

    /**
     * The Not Applicable User Count.
     * Number of not applicable users.
     */
    @SerializedName("notApplicableUserCount")
    @Expose
    public Integer notApplicableUserCount;

    /**
     * The Remediated Device Count.
     * Number of remediated devices.
     */
    @SerializedName("remediatedDeviceCount")
    @Expose
    public Integer remediatedDeviceCount;

    /**
     * The Remediated User Count.
     * Number of remediated users.
     */
    @SerializedName("remediatedUserCount")
    @Expose
    public Integer remediatedUserCount;

    /**
     * The Unknown Device Count.
     * Number of unknown devices.
     */
    @SerializedName("unknownDeviceCount")
    @Expose
    public Integer unknownDeviceCount;

    /**
     * The Unknown User Count.
     * Number of unknown users.
     */
    @SerializedName("unknownUserCount")
    @Expose
    public Integer unknownUserCount;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
