// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Text Column.
 */
public class TextColumn implements IJsonBackedObject {

    @SerializedName("@odata.type")
    @Expose
    public String oDataType;

    private transient AdditionalDataManager additionalDataManager = new AdditionalDataManager(this);

    @Override
    public final AdditionalDataManager additionalDataManager() {
        return additionalDataManager;
    }

    /**
     * The Allow Multiple Lines.
     * Whether to allow multiple lines of text.
     */
    @SerializedName("allowMultipleLines")
    @Expose
    public Boolean allowMultipleLines;

    /**
     * The Append Changes To Existing Text.
     * Whether updates to this column should replace existing text, or append to it.
     */
    @SerializedName("appendChangesToExistingText")
    @Expose
    public Boolean appendChangesToExistingText;

    /**
     * The Lines For Editing.
     * The size of the text box.
     */
    @SerializedName("linesForEditing")
    @Expose
    public Integer linesForEditing;

    /**
     * The Max Length.
     * The maximum number of characters for the value.
     */
    @SerializedName("maxLength")
    @Expose
    public Integer maxLength;

    /**
     * The Text Type.
     * The type of text being stored. Must be one of plain or richText
     */
    @SerializedName("textType")
    @Expose
    public String textType;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;

    }
}
