// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.models.extensions;
import com.microsoft.graph.serializer.ISerializer;
import com.microsoft.graph.serializer.IJsonBackedObject;
import com.microsoft.graph.serializer.AdditionalDataManager;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.models.extensions.WorkbookChartAxes;
import com.microsoft.graph.models.extensions.WorkbookChartDataLabels;
import com.microsoft.graph.models.extensions.WorkbookChartAreaFormat;
import com.microsoft.graph.models.extensions.WorkbookChartLegend;
import com.microsoft.graph.models.extensions.WorkbookChartSeries;
import com.microsoft.graph.models.extensions.WorkbookChartTitle;
import com.microsoft.graph.models.extensions.WorkbookWorksheet;
import com.microsoft.graph.models.extensions.Entity;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesCollectionResponse;
import com.microsoft.graph.requests.extensions.WorkbookChartSeriesCollectionPage;


import com.google.gson.JsonObject;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import java.util.HashMap;
import java.util.Map;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Chart.
 */
public class WorkbookChart extends Entity implements IJsonBackedObject {


    /**
     * The Height.
     * Represents the height, in points, of the chart object.
     */
    @SerializedName("height")
    @Expose
    public Double height;

    /**
     * The Left.
     * The distance, in points, from the left side of the chart to the worksheet origin.
     */
    @SerializedName("left")
    @Expose
    public Double left;

    /**
     * The Name.
     * Represents the name of a chart object.
     */
    @SerializedName("name")
    @Expose
    public String name;

    /**
     * The Top.
     * Represents the distance, in points, from the top edge of the object to the top of row 1 (on a worksheet) or the top of the chart area (on a chart).
     */
    @SerializedName("top")
    @Expose
    public Double top;

    /**
     * The Width.
     * Represents the width, in points, of the chart object.
     */
    @SerializedName("width")
    @Expose
    public Double width;

    /**
     * The Axes.
     * Represents chart axes. Read-only.
     */
    @SerializedName("axes")
    @Expose
    public WorkbookChartAxes axes;

    /**
     * The Data Labels.
     * Represents the datalabels on the chart. Read-only.
     */
    @SerializedName("dataLabels")
    @Expose
    public WorkbookChartDataLabels dataLabels;

    /**
     * The Format.
     * Encapsulates the format properties for the chart area. Read-only.
     */
    @SerializedName("format")
    @Expose
    public WorkbookChartAreaFormat format;

    /**
     * The Legend.
     * Represents the legend for the chart. Read-only.
     */
    @SerializedName("legend")
    @Expose
    public WorkbookChartLegend legend;

    /**
     * The Series.
     * Represents either a single series or collection of series in the chart. Read-only.
     */
    @SerializedName("series")
    @Expose
    public WorkbookChartSeriesCollectionPage series;

    /**
     * The Title.
     * Represents the title of the specified chart, including the text, visibility, position and formating of the title. Read-only.
     */
    @SerializedName("title")
    @Expose
    public WorkbookChartTitle title;

    /**
     * The Worksheet.
     * The worksheet containing the current chart. Read-only.
     */
    @SerializedName("worksheet")
    @Expose
    public WorkbookWorksheet worksheet;


    /**
     * The raw representation of this class
     */
    private JsonObject rawObject;

    /**
     * The serializer
     */
    private ISerializer serializer;

    /**
     * Gets the raw representation of this class
     *
     * @return the raw representation of this class
     */
    public JsonObject getRawObject() {
        return rawObject;
    }

    /**
     * Gets serializer
     *
     * @return the serializer
     */
    protected ISerializer getSerializer() {
        return serializer;
    }

    /**
     * Sets the raw JSON object
     *
     * @param serializer the serializer
     * @param json the JSON object to set this object to
     */
    public void setRawObject(final ISerializer serializer, final JsonObject json) {
        this.serializer = serializer;
        rawObject = json;


        if (json.has("series")) {
            final WorkbookChartSeriesCollectionResponse response = new WorkbookChartSeriesCollectionResponse();
            if (json.has("series@odata.nextLink")) {
                response.nextLink = json.get("series@odata.nextLink").getAsString();
            }

            final JsonObject[] sourceArray = serializer.deserializeObject(json.get("series").toString(), JsonObject[].class);
            final WorkbookChartSeries[] array = new WorkbookChartSeries[sourceArray.length];
            for (int i = 0; i < sourceArray.length; i++) {
                array[i] = serializer.deserializeObject(sourceArray[i].toString(), WorkbookChartSeries.class);
                array[i].setRawObject(serializer, sourceArray[i]);
            }
            response.value = Arrays.asList(array);
            series = new WorkbookChartSeriesCollectionPage(response, null);
        }
    }
}
