// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DeviceComplianceDeviceOverview;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Device Compliance Device Overview Request.
 */
public class DeviceComplianceDeviceOverviewRequest extends BaseRequest implements IDeviceComplianceDeviceOverviewRequest {
	
    /**
     * The request for the DeviceComplianceDeviceOverview
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DeviceComplianceDeviceOverviewRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DeviceComplianceDeviceOverview.class);
    }

    /**
     * Gets the DeviceComplianceDeviceOverview from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DeviceComplianceDeviceOverview> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DeviceComplianceDeviceOverview from the service
     *
     * @return the DeviceComplianceDeviceOverview from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceDeviceOverview get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DeviceComplianceDeviceOverview> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DeviceComplianceDeviceOverview with a source
     *
     * @param sourceDeviceComplianceDeviceOverview the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DeviceComplianceDeviceOverview sourceDeviceComplianceDeviceOverview, final ICallback<DeviceComplianceDeviceOverview> callback) {
        send(HttpMethod.PATCH, callback, sourceDeviceComplianceDeviceOverview);
    }

    /**
     * Patches this DeviceComplianceDeviceOverview with a source
     *
     * @param sourceDeviceComplianceDeviceOverview the source object with updates
     * @return the updated DeviceComplianceDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceDeviceOverview patch(final DeviceComplianceDeviceOverview sourceDeviceComplianceDeviceOverview) throws ClientException {
        return send(HttpMethod.PATCH, sourceDeviceComplianceDeviceOverview);
    }

    /**
     * Creates a DeviceComplianceDeviceOverview with a new object
     *
     * @param newDeviceComplianceDeviceOverview the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DeviceComplianceDeviceOverview newDeviceComplianceDeviceOverview, final ICallback<DeviceComplianceDeviceOverview> callback) {
        send(HttpMethod.POST, callback, newDeviceComplianceDeviceOverview);
    }

    /**
     * Creates a DeviceComplianceDeviceOverview with a new object
     *
     * @param newDeviceComplianceDeviceOverview the new object to create
     * @return the created DeviceComplianceDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceDeviceOverview post(final DeviceComplianceDeviceOverview newDeviceComplianceDeviceOverview) throws ClientException {
        return send(HttpMethod.POST, newDeviceComplianceDeviceOverview);
    }

    /**
     * Creates a DeviceComplianceDeviceOverview with a new object
     *
     * @param newDeviceComplianceDeviceOverview the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final DeviceComplianceDeviceOverview newDeviceComplianceDeviceOverview, final ICallback<DeviceComplianceDeviceOverview> callback) {
        send(HttpMethod.PUT, callback, newDeviceComplianceDeviceOverview);
    }

    /**
     * Creates a DeviceComplianceDeviceOverview with a new object
     *
     * @param newDeviceComplianceDeviceOverview the object to create/update
     * @return the created DeviceComplianceDeviceOverview
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DeviceComplianceDeviceOverview put(final DeviceComplianceDeviceOverview newDeviceComplianceDeviceOverview) throws ClientException {
        return send(HttpMethod.PUT, newDeviceComplianceDeviceOverview);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDeviceComplianceDeviceOverviewRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DeviceComplianceDeviceOverviewRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDeviceComplianceDeviceOverviewRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DeviceComplianceDeviceOverviewRequest)this;
     }

}

