// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DirectoryObjectPartnerReference;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Directory Object Partner Reference Request.
 */
public class DirectoryObjectPartnerReferenceRequest extends BaseRequest implements IDirectoryObjectPartnerReferenceRequest {
	
    /**
     * The request for the DirectoryObjectPartnerReference
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public DirectoryObjectPartnerReferenceRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectPartnerReference.class);
    }

    /**
     * Gets the DirectoryObjectPartnerReference from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<DirectoryObjectPartnerReference> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the DirectoryObjectPartnerReference from the service
     *
     * @return the DirectoryObjectPartnerReference from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DirectoryObjectPartnerReference get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<DirectoryObjectPartnerReference> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this DirectoryObjectPartnerReference with a source
     *
     * @param sourceDirectoryObjectPartnerReference the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference, final ICallback<DirectoryObjectPartnerReference> callback) {
        send(HttpMethod.PATCH, callback, sourceDirectoryObjectPartnerReference);
    }

    /**
     * Patches this DirectoryObjectPartnerReference with a source
     *
     * @param sourceDirectoryObjectPartnerReference the source object with updates
     * @return the updated DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DirectoryObjectPartnerReference patch(final DirectoryObjectPartnerReference sourceDirectoryObjectPartnerReference) throws ClientException {
        return send(HttpMethod.PATCH, sourceDirectoryObjectPartnerReference);
    }

    /**
     * Creates a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final ICallback<DirectoryObjectPartnerReference> callback) {
        send(HttpMethod.POST, callback, newDirectoryObjectPartnerReference);
    }

    /**
     * Creates a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the new object to create
     * @return the created DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DirectoryObjectPartnerReference post(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference) throws ClientException {
        return send(HttpMethod.POST, newDirectoryObjectPartnerReference);
    }

    /**
     * Creates a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference, final ICallback<DirectoryObjectPartnerReference> callback) {
        send(HttpMethod.PUT, callback, newDirectoryObjectPartnerReference);
    }

    /**
     * Creates a DirectoryObjectPartnerReference with a new object
     *
     * @param newDirectoryObjectPartnerReference the object to create/update
     * @return the created DirectoryObjectPartnerReference
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public DirectoryObjectPartnerReference put(final DirectoryObjectPartnerReference newDirectoryObjectPartnerReference) throws ClientException {
        return send(HttpMethod.PUT, newDirectoryObjectPartnerReference);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IDirectoryObjectPartnerReferenceRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (DirectoryObjectPartnerReferenceRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IDirectoryObjectPartnerReferenceRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (DirectoryObjectPartnerReferenceRequest)this;
     }

}

