// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.DriveRecipient;
import com.microsoft.graph.models.extensions.Permission;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IDriveItemInviteCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionPage;
import com.microsoft.graph.requests.extensions.DriveItemInviteCollectionResponse;
import com.google.gson.JsonObject;
import com.google.gson.annotations.SerializedName;
import com.google.gson.annotations.Expose;
import com.microsoft.graph.http.IBaseCollectionPage;
import com.microsoft.graph.http.BaseCollectionPage;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Drive Item Invite Collection Page.
 */
public class DriveItemInviteCollectionPage extends BaseCollectionPage<Permission, IDriveItemInviteCollectionRequestBuilder> implements IDriveItemInviteCollectionPage {

    /**
     * A collection page for Permission.
     *
     * @param response The serialized DriveItemInviteCollectionResponse from the service
     * @param builder The request builder for the next collection page
     */
    public DriveItemInviteCollectionPage(final DriveItemInviteCollectionResponse response, final IDriveItemInviteCollectionRequestBuilder builder) {
       super(response.value, builder);
    }
}
