// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.AndroidLobApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Android Lob App Request.
 */
public interface IAndroidLobAppRequest extends IHttpRequest {

    /**
     * Gets the AndroidLobApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<AndroidLobApp> callback);

    /**
     * Gets the AndroidLobApp from the service
     *
     * @return the AndroidLobApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidLobApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<AndroidLobApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this AndroidLobApp with a source
     *
     * @param sourceAndroidLobApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final AndroidLobApp sourceAndroidLobApp, final ICallback<AndroidLobApp> callback);

    /**
     * Patches this AndroidLobApp with a source
     *
     * @param sourceAndroidLobApp the source object with updates
     * @return the updated AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidLobApp patch(final AndroidLobApp sourceAndroidLobApp) throws ClientException;

    /**
     * Posts a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final AndroidLobApp newAndroidLobApp, final ICallback<AndroidLobApp> callback);

    /**
     * Posts a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the new object to create
     * @return the created AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidLobApp post(final AndroidLobApp newAndroidLobApp) throws ClientException;

    /**
     * Posts a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final AndroidLobApp newAndroidLobApp, final ICallback<AndroidLobApp> callback);

    /**
     * Posts a AndroidLobApp with a new object
     *
     * @param newAndroidLobApp the object to create/update
     * @return the created AndroidLobApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    AndroidLobApp put(final AndroidLobApp newAndroidLobApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IAndroidLobAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IAndroidLobAppRequest expand(final String value);

}

