// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.CalendarGroup;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Calendar Group Request.
 */
public interface ICalendarGroupRequest extends IHttpRequest {

    /**
     * Gets the CalendarGroup from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<CalendarGroup> callback);

    /**
     * Gets the CalendarGroup from the service
     *
     * @return the CalendarGroup from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarGroup get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<CalendarGroup> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this CalendarGroup with a source
     *
     * @param sourceCalendarGroup the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final CalendarGroup sourceCalendarGroup, final ICallback<CalendarGroup> callback);

    /**
     * Patches this CalendarGroup with a source
     *
     * @param sourceCalendarGroup the source object with updates
     * @return the updated CalendarGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarGroup patch(final CalendarGroup sourceCalendarGroup) throws ClientException;

    /**
     * Posts a CalendarGroup with a new object
     *
     * @param newCalendarGroup the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final CalendarGroup newCalendarGroup, final ICallback<CalendarGroup> callback);

    /**
     * Posts a CalendarGroup with a new object
     *
     * @param newCalendarGroup the new object to create
     * @return the created CalendarGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarGroup post(final CalendarGroup newCalendarGroup) throws ClientException;

    /**
     * Posts a CalendarGroup with a new object
     *
     * @param newCalendarGroup the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final CalendarGroup newCalendarGroup, final ICallback<CalendarGroup> callback);

    /**
     * Posts a CalendarGroup with a new object
     *
     * @param newCalendarGroup the object to create/update
     * @return the created CalendarGroup
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    CalendarGroup put(final CalendarGroup newCalendarGroup) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ICalendarGroupRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ICalendarGroupRequest expand(final String value);

}

