// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ClaimsMappingPolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.ClaimsMappingPolicy;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;


// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Claims Mapping Policy With Reference Request.
 */
public interface IClaimsMappingPolicyWithReferenceRequest extends IHttpRequest {

    void post(final ClaimsMappingPolicy newClaimsMappingPolicy, final IJsonBackedObject payload, final ICallback<ClaimsMappingPolicy> callback);

    ClaimsMappingPolicy post(final ClaimsMappingPolicy newClaimsMappingPolicy, final IJsonBackedObject payload) throws ClientException;

    void get(final ICallback<ClaimsMappingPolicy> callback);

    ClaimsMappingPolicy get() throws ClientException;

	void delete(final ICallback<ClaimsMappingPolicy> callback);

	void delete() throws ClientException;

	void patch(final ClaimsMappingPolicy sourceClaimsMappingPolicy, final ICallback<ClaimsMappingPolicy> callback);

	ClaimsMappingPolicy patch(final ClaimsMappingPolicy sourceClaimsMappingPolicy) throws ClientException;

    IClaimsMappingPolicyWithReferenceRequest select(final String value);

    IClaimsMappingPolicyWithReferenceRequest expand(final String value);

}
