// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.IosStoreApp;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Ios Store App Request.
 */
public interface IIosStoreAppRequest extends IHttpRequest {

    /**
     * Gets the IosStoreApp from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<IosStoreApp> callback);

    /**
     * Gets the IosStoreApp from the service
     *
     * @return the IosStoreApp from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosStoreApp get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<IosStoreApp> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this IosStoreApp with a source
     *
     * @param sourceIosStoreApp the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final IosStoreApp sourceIosStoreApp, final ICallback<IosStoreApp> callback);

    /**
     * Patches this IosStoreApp with a source
     *
     * @param sourceIosStoreApp the source object with updates
     * @return the updated IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosStoreApp patch(final IosStoreApp sourceIosStoreApp) throws ClientException;

    /**
     * Posts a IosStoreApp with a new object
     *
     * @param newIosStoreApp the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final IosStoreApp newIosStoreApp, final ICallback<IosStoreApp> callback);

    /**
     * Posts a IosStoreApp with a new object
     *
     * @param newIosStoreApp the new object to create
     * @return the created IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosStoreApp post(final IosStoreApp newIosStoreApp) throws ClientException;

    /**
     * Posts a IosStoreApp with a new object
     *
     * @param newIosStoreApp the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final IosStoreApp newIosStoreApp, final ICallback<IosStoreApp> callback);

    /**
     * Posts a IosStoreApp with a new object
     *
     * @param newIosStoreApp the object to create/update
     * @return the created IosStoreApp
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    IosStoreApp put(final IosStoreApp newIosStoreApp) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IIosStoreAppRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IIosStoreAppRequest expand(final String value);

}

