// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.LicenseDetails;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the License Details Request.
 */
public interface ILicenseDetailsRequest extends IHttpRequest {

    /**
     * Gets the LicenseDetails from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<LicenseDetails> callback);

    /**
     * Gets the LicenseDetails from the service
     *
     * @return the LicenseDetails from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LicenseDetails get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<LicenseDetails> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this LicenseDetails with a source
     *
     * @param sourceLicenseDetails the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final LicenseDetails sourceLicenseDetails, final ICallback<LicenseDetails> callback);

    /**
     * Patches this LicenseDetails with a source
     *
     * @param sourceLicenseDetails the source object with updates
     * @return the updated LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LicenseDetails patch(final LicenseDetails sourceLicenseDetails) throws ClientException;

    /**
     * Posts a LicenseDetails with a new object
     *
     * @param newLicenseDetails the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final LicenseDetails newLicenseDetails, final ICallback<LicenseDetails> callback);

    /**
     * Posts a LicenseDetails with a new object
     *
     * @param newLicenseDetails the new object to create
     * @return the created LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LicenseDetails post(final LicenseDetails newLicenseDetails) throws ClientException;

    /**
     * Posts a LicenseDetails with a new object
     *
     * @param newLicenseDetails the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final LicenseDetails newLicenseDetails, final ICallback<LicenseDetails> callback);

    /**
     * Posts a LicenseDetails with a new object
     *
     * @param newLicenseDetails the object to create/update
     * @return the created LicenseDetails
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LicenseDetails put(final LicenseDetails newLicenseDetails) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ILicenseDetailsRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ILicenseDetailsRequest expand(final String value);

}

