// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.LocalizedNotificationMessage;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Localized Notification Message Request.
 */
public interface ILocalizedNotificationMessageRequest extends IHttpRequest {

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<LocalizedNotificationMessage> callback);

    /**
     * Gets the LocalizedNotificationMessage from the service
     *
     * @return the LocalizedNotificationMessage from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LocalizedNotificationMessage get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<LocalizedNotificationMessage> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final LocalizedNotificationMessage sourceLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback);

    /**
     * Patches this LocalizedNotificationMessage with a source
     *
     * @param sourceLocalizedNotificationMessage the source object with updates
     * @return the updated LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LocalizedNotificationMessage patch(final LocalizedNotificationMessage sourceLocalizedNotificationMessage) throws ClientException;

    /**
     * Posts a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final LocalizedNotificationMessage newLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback);

    /**
     * Posts a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the new object to create
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LocalizedNotificationMessage post(final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException;

    /**
     * Posts a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final LocalizedNotificationMessage newLocalizedNotificationMessage, final ICallback<LocalizedNotificationMessage> callback);

    /**
     * Posts a LocalizedNotificationMessage with a new object
     *
     * @param newLocalizedNotificationMessage the object to create/update
     * @return the created LocalizedNotificationMessage
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    LocalizedNotificationMessage put(final LocalizedNotificationMessage newLocalizedNotificationMessage) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    ILocalizedNotificationMessageRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    ILocalizedNotificationMessageRequest expand(final String value);

}

