// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.ManagedDeviceMobileAppConfigurationUserSummary;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Managed Device Mobile App Configuration User Summary Request.
 */
public interface IManagedDeviceMobileAppConfigurationUserSummaryRequest extends IHttpRequest {

    /**
     * Gets the ManagedDeviceMobileAppConfigurationUserSummary from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<ManagedDeviceMobileAppConfigurationUserSummary> callback);

    /**
     * Gets the ManagedDeviceMobileAppConfigurationUserSummary from the service
     *
     * @return the ManagedDeviceMobileAppConfigurationUserSummary from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationUserSummary get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<ManagedDeviceMobileAppConfigurationUserSummary> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this ManagedDeviceMobileAppConfigurationUserSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationUserSummary the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final ManagedDeviceMobileAppConfigurationUserSummary sourceManagedDeviceMobileAppConfigurationUserSummary, final ICallback<ManagedDeviceMobileAppConfigurationUserSummary> callback);

    /**
     * Patches this ManagedDeviceMobileAppConfigurationUserSummary with a source
     *
     * @param sourceManagedDeviceMobileAppConfigurationUserSummary the source object with updates
     * @return the updated ManagedDeviceMobileAppConfigurationUserSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationUserSummary patch(final ManagedDeviceMobileAppConfigurationUserSummary sourceManagedDeviceMobileAppConfigurationUserSummary) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationUserSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserSummary the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final ManagedDeviceMobileAppConfigurationUserSummary newManagedDeviceMobileAppConfigurationUserSummary, final ICallback<ManagedDeviceMobileAppConfigurationUserSummary> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationUserSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserSummary the new object to create
     * @return the created ManagedDeviceMobileAppConfigurationUserSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationUserSummary post(final ManagedDeviceMobileAppConfigurationUserSummary newManagedDeviceMobileAppConfigurationUserSummary) throws ClientException;

    /**
     * Posts a ManagedDeviceMobileAppConfigurationUserSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserSummary the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final ManagedDeviceMobileAppConfigurationUserSummary newManagedDeviceMobileAppConfigurationUserSummary, final ICallback<ManagedDeviceMobileAppConfigurationUserSummary> callback);

    /**
     * Posts a ManagedDeviceMobileAppConfigurationUserSummary with a new object
     *
     * @param newManagedDeviceMobileAppConfigurationUserSummary the object to create/update
     * @return the created ManagedDeviceMobileAppConfigurationUserSummary
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    ManagedDeviceMobileAppConfigurationUserSummary put(final ManagedDeviceMobileAppConfigurationUserSummary newManagedDeviceMobileAppConfigurationUserSummary) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationUserSummaryRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IManagedDeviceMobileAppConfigurationUserSummaryRequest expand(final String value);

}

