// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.OAuth2PermissionGrant;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.models.extensions.OAuth2PermissionGrant;
import com.microsoft.graph.http.IHttpRequest;
import com.microsoft.graph.serializer.IJsonBackedObject;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the OAuth2Permission Grant Reference Request.
 */
public interface IOAuth2PermissionGrantReferenceRequest extends IHttpRequest {

    void delete(final ICallback<OAuth2PermissionGrant> callback);

    OAuth2PermissionGrant delete() throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOAuth2PermissionGrantReferenceRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOAuth2PermissionGrantReferenceRequest expand(final String value);

    /**
     * Puts the OAuth2PermissionGrant
     *
     * @param srcOAuth2PermissionGrant the OAuth2PermissionGrant to PUT
     * @param callback the callback to be called after success or failure
     */
    void put(OAuth2PermissionGrant srcOAuth2PermissionGrant, final ICallback<OAuth2PermissionGrant> callback);

    /**
     * Puts the OAuth2PermissionGrant
     *
     * @param srcOAuth2PermissionGrant the OAuth2PermissionGrant to PUT
     * @return the OAuth2PermissionGrant
     * @throws ClientException an exception occurs if there was an error while the request was sent
     */
    OAuth2PermissionGrant put(OAuth2PermissionGrant srcOAuth2PermissionGrant) throws ClientException;
}
