// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OnenoteOperation;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Onenote Operation Request.
 */
public interface IOnenoteOperationRequest extends IHttpRequest {

    /**
     * Gets the OnenoteOperation from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<OnenoteOperation> callback);

    /**
     * Gets the OnenoteOperation from the service
     *
     * @return the OnenoteOperation from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteOperation get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<OnenoteOperation> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OnenoteOperation with a source
     *
     * @param sourceOnenoteOperation the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OnenoteOperation sourceOnenoteOperation, final ICallback<OnenoteOperation> callback);

    /**
     * Patches this OnenoteOperation with a source
     *
     * @param sourceOnenoteOperation the source object with updates
     * @return the updated OnenoteOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteOperation patch(final OnenoteOperation sourceOnenoteOperation) throws ClientException;

    /**
     * Posts a OnenoteOperation with a new object
     *
     * @param newOnenoteOperation the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OnenoteOperation newOnenoteOperation, final ICallback<OnenoteOperation> callback);

    /**
     * Posts a OnenoteOperation with a new object
     *
     * @param newOnenoteOperation the new object to create
     * @return the created OnenoteOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteOperation post(final OnenoteOperation newOnenoteOperation) throws ClientException;

    /**
     * Posts a OnenoteOperation with a new object
     *
     * @param newOnenoteOperation the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OnenoteOperation newOnenoteOperation, final ICallback<OnenoteOperation> callback);

    /**
     * Posts a OnenoteOperation with a new object
     *
     * @param newOnenoteOperation the object to create/update
     * @return the created OnenoteOperation
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnenoteOperation put(final OnenoteOperation newOnenoteOperation) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOnenoteOperationRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOnenoteOperationRequest expand(final String value);

}

