// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.OnlineMeeting;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Online Meeting Request.
 */
public interface IOnlineMeetingRequest extends IHttpRequest {

    /**
     * Gets the OnlineMeeting from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<OnlineMeeting> callback);

    /**
     * Gets the OnlineMeeting from the service
     *
     * @return the OnlineMeeting from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnlineMeeting get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<OnlineMeeting> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this OnlineMeeting with a source
     *
     * @param sourceOnlineMeeting the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final OnlineMeeting sourceOnlineMeeting, final ICallback<OnlineMeeting> callback);

    /**
     * Patches this OnlineMeeting with a source
     *
     * @param sourceOnlineMeeting the source object with updates
     * @return the updated OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnlineMeeting patch(final OnlineMeeting sourceOnlineMeeting) throws ClientException;

    /**
     * Posts a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final OnlineMeeting newOnlineMeeting, final ICallback<OnlineMeeting> callback);

    /**
     * Posts a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the new object to create
     * @return the created OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnlineMeeting post(final OnlineMeeting newOnlineMeeting) throws ClientException;

    /**
     * Posts a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final OnlineMeeting newOnlineMeeting, final ICallback<OnlineMeeting> callback);

    /**
     * Posts a OnlineMeeting with a new object
     *
     * @param newOnlineMeeting the object to create/update
     * @return the created OnlineMeeting
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    OnlineMeeting put(final OnlineMeeting newOnlineMeeting) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IOnlineMeetingRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IOnlineMeetingRequest expand(final String value);

}

