// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookChartAxisTitle;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Chart Axis Title Request.
 */
public interface IWorkbookChartAxisTitleRequest extends IHttpRequest {

    /**
     * Gets the WorkbookChartAxisTitle from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Gets the WorkbookChartAxisTitle from the service
     *
     * @return the WorkbookChartAxisTitle from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitle get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookChartAxisTitle with a source
     *
     * @param sourceWorkbookChartAxisTitle the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Patches this WorkbookChartAxisTitle with a source
     *
     * @param sourceWorkbookChartAxisTitle the source object with updates
     * @return the updated WorkbookChartAxisTitle
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitle patch(final WorkbookChartAxisTitle sourceWorkbookChartAxisTitle) throws ClientException;

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     *
     * @param newWorkbookChartAxisTitle the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     *
     * @param newWorkbookChartAxisTitle the new object to create
     * @return the created WorkbookChartAxisTitle
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitle post(final WorkbookChartAxisTitle newWorkbookChartAxisTitle) throws ClientException;

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     *
     * @param newWorkbookChartAxisTitle the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookChartAxisTitle newWorkbookChartAxisTitle, final ICallback<WorkbookChartAxisTitle> callback);

    /**
     * Posts a WorkbookChartAxisTitle with a new object
     *
     * @param newWorkbookChartAxisTitle the object to create/update
     * @return the created WorkbookChartAxisTitle
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookChartAxisTitle put(final WorkbookChartAxisTitle newWorkbookChartAxisTitle) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookChartAxisTitleRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookChartAxisTitleRequest expand(final String value);

}

