// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.models.extensions.WorkbookFunctionResult;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.http.IHttpRequest;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The interface for the Workbook Function Result Request.
 */
public interface IWorkbookFunctionResultRequest extends IHttpRequest {

    /**
     * Gets the WorkbookFunctionResult from the service
     *
     * @param callback the callback to be called after success or failure
     */
    void get(final ICallback<WorkbookFunctionResult> callback);

    /**
     * Gets the WorkbookFunctionResult from the service
     *
     * @return the WorkbookFunctionResult from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFunctionResult get() throws ClientException;

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    void delete(final ICallback<WorkbookFunctionResult> callback);

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    void delete() throws ClientException;

    /**
     * Patches this WorkbookFunctionResult with a source
     *
     * @param sourceWorkbookFunctionResult the source object with updates
     * @param callback the callback to be called after success or failure
     */
    void patch(final WorkbookFunctionResult sourceWorkbookFunctionResult, final ICallback<WorkbookFunctionResult> callback);

    /**
     * Patches this WorkbookFunctionResult with a source
     *
     * @param sourceWorkbookFunctionResult the source object with updates
     * @return the updated WorkbookFunctionResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFunctionResult patch(final WorkbookFunctionResult sourceWorkbookFunctionResult) throws ClientException;

    /**
     * Posts a WorkbookFunctionResult with a new object
     *
     * @param newWorkbookFunctionResult the new object to create
     * @param callback the callback to be called after success or failure
     */
    void post(final WorkbookFunctionResult newWorkbookFunctionResult, final ICallback<WorkbookFunctionResult> callback);

    /**
     * Posts a WorkbookFunctionResult with a new object
     *
     * @param newWorkbookFunctionResult the new object to create
     * @return the created WorkbookFunctionResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFunctionResult post(final WorkbookFunctionResult newWorkbookFunctionResult) throws ClientException;

    /**
     * Posts a WorkbookFunctionResult with a new object
     *
     * @param newWorkbookFunctionResult the object to create/update
     * @param callback the callback to be called after success or failure
     */
    void put(final WorkbookFunctionResult newWorkbookFunctionResult, final ICallback<WorkbookFunctionResult> callback);

    /**
     * Posts a WorkbookFunctionResult with a new object
     *
     * @param newWorkbookFunctionResult the object to create/update
     * @return the created WorkbookFunctionResult
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    WorkbookFunctionResult put(final WorkbookFunctionResult newWorkbookFunctionResult) throws ClientException;

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    IWorkbookFunctionResultRequest select(final String value);

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    IWorkbookFunctionResultRequest expand(final String value);

}

