// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IManagedDeviceCleanWindowsDeviceRequest;
import com.microsoft.graph.requests.extensions.ManagedDeviceCleanWindowsDeviceRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Managed Device Clean Windows Device Request Builder.
 */
public class ManagedDeviceCleanWindowsDeviceRequestBuilder extends BaseActionRequestBuilder implements IManagedDeviceCleanWindowsDeviceRequestBuilder {

    /**
     * The request builder for this ManagedDeviceCleanWindowsDevice
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     * @param keepUserData the keepUserData
     */
    public ManagedDeviceCleanWindowsDeviceRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions, final Boolean keepUserData) {
        super(requestUrl, client, requestOptions);
        bodyParams.put("keepUserData", keepUserData);
    }

    /**
     * Creates the IManagedDeviceCleanWindowsDeviceRequest
     *
     * @return the IManagedDeviceCleanWindowsDeviceRequest instance
     */
    public IManagedDeviceCleanWindowsDeviceRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IManagedDeviceCleanWindowsDeviceRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IManagedDeviceCleanWindowsDeviceRequest instance
     */
    public IManagedDeviceCleanWindowsDeviceRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        ManagedDeviceCleanWindowsDeviceRequest request = new ManagedDeviceCleanWindowsDeviceRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        if (hasParameter("keepUserData")) {
            request.body.keepUserData = getParameter("keepUserData");
        }

        return request;
    }
}
