// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IMessageSendRequest;
import com.microsoft.graph.requests.extensions.MessageSendRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Message Send Request Builder.
 */
public class MessageSendRequestBuilder extends BaseActionRequestBuilder implements IMessageSendRequestBuilder {

    /**
     * The request builder for this MessageSend
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public MessageSendRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IMessageSendRequest
     *
     * @return the IMessageSendRequest instance
     */
    public IMessageSendRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IMessageSendRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IMessageSendRequest instance
     */
    public IMessageSendRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        MessageSendRequest request = new MessageSendRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
