// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.TimeOffReason;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Time Off Reason Request.
 */
public class TimeOffReasonRequest extends BaseRequest implements ITimeOffReasonRequest {
	
    /**
     * The request for the TimeOffReason
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TimeOffReasonRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, TimeOffReason.class);
    }

    /**
     * Gets the TimeOffReason from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<TimeOffReason> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the TimeOffReason from the service
     *
     * @return the TimeOffReason from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TimeOffReason get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<TimeOffReason> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this TimeOffReason with a source
     *
     * @param sourceTimeOffReason the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final TimeOffReason sourceTimeOffReason, final ICallback<TimeOffReason> callback) {
        send(HttpMethod.PATCH, callback, sourceTimeOffReason);
    }

    /**
     * Patches this TimeOffReason with a source
     *
     * @param sourceTimeOffReason the source object with updates
     * @return the updated TimeOffReason
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TimeOffReason patch(final TimeOffReason sourceTimeOffReason) throws ClientException {
        return send(HttpMethod.PATCH, sourceTimeOffReason);
    }

    /**
     * Creates a TimeOffReason with a new object
     *
     * @param newTimeOffReason the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final TimeOffReason newTimeOffReason, final ICallback<TimeOffReason> callback) {
        send(HttpMethod.POST, callback, newTimeOffReason);
    }

    /**
     * Creates a TimeOffReason with a new object
     *
     * @param newTimeOffReason the new object to create
     * @return the created TimeOffReason
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TimeOffReason post(final TimeOffReason newTimeOffReason) throws ClientException {
        return send(HttpMethod.POST, newTimeOffReason);
    }

    /**
     * Creates a TimeOffReason with a new object
     *
     * @param newTimeOffReason the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final TimeOffReason newTimeOffReason, final ICallback<TimeOffReason> callback) {
        send(HttpMethod.PUT, callback, newTimeOffReason);
    }

    /**
     * Creates a TimeOffReason with a new object
     *
     * @param newTimeOffReason the object to create/update
     * @return the created TimeOffReason
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public TimeOffReason put(final TimeOffReason newTimeOffReason) throws ClientException {
        return send(HttpMethod.PUT, newTimeOffReason);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITimeOffReasonRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TimeOffReasonRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITimeOffReasonRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TimeOffReasonRequest)this;
     }

}

