// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.Trending;
import com.microsoft.graph.requests.extensions.IEntityRequestBuilder;
import com.microsoft.graph.requests.extensions.EntityRequestBuilder;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Trending Request.
 */
public class TrendingRequest extends BaseRequest implements ITrendingRequest {
	
    /**
     * The request for the Trending
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public TrendingRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, Trending.class);
    }

    /**
     * Gets the Trending from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<Trending> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the Trending from the service
     *
     * @return the Trending from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Trending get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<Trending> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this Trending with a source
     *
     * @param sourceTrending the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final Trending sourceTrending, final ICallback<Trending> callback) {
        send(HttpMethod.PATCH, callback, sourceTrending);
    }

    /**
     * Patches this Trending with a source
     *
     * @param sourceTrending the source object with updates
     * @return the updated Trending
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Trending patch(final Trending sourceTrending) throws ClientException {
        return send(HttpMethod.PATCH, sourceTrending);
    }

    /**
     * Creates a Trending with a new object
     *
     * @param newTrending the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final Trending newTrending, final ICallback<Trending> callback) {
        send(HttpMethod.POST, callback, newTrending);
    }

    /**
     * Creates a Trending with a new object
     *
     * @param newTrending the new object to create
     * @return the created Trending
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Trending post(final Trending newTrending) throws ClientException {
        return send(HttpMethod.POST, newTrending);
    }

    /**
     * Creates a Trending with a new object
     *
     * @param newTrending the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final Trending newTrending, final ICallback<Trending> callback) {
        send(HttpMethod.PUT, callback, newTrending);
    }

    /**
     * Creates a Trending with a new object
     *
     * @param newTrending the object to create/update
     * @return the created Trending
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public Trending put(final Trending newTrending) throws ClientException {
        return send(HttpMethod.PUT, newTrending);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public ITrendingRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (TrendingRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public ITrendingRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (TrendingRequest)this;
     }

}

