// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.ManagedAppPolicy;
import java.util.Arrays;
import java.util.EnumSet;

import com.microsoft.graph.requests.extensions.IUserGetManagedAppPoliciesCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.UserGetManagedAppPoliciesCollectionPage;
import com.microsoft.graph.requests.extensions.UserGetManagedAppPoliciesCollectionResponse;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.concurrency.IExecutors;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the User Get Managed App Policies Collection Request.
 */
public class UserGetManagedAppPoliciesCollectionRequest extends BaseCollectionRequest<UserGetManagedAppPoliciesCollectionResponse, IUserGetManagedAppPoliciesCollectionPage> implements IUserGetManagedAppPoliciesCollectionRequest {


    /**
     * The request for this UserGetManagedAppPolicies
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public UserGetManagedAppPoliciesCollectionRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, UserGetManagedAppPoliciesCollectionResponse.class, IUserGetManagedAppPoliciesCollectionPage.class);
    }


    public void get(final ICallback<IUserGetManagedAppPoliciesCollectionPage> callback) {
        final IExecutors executors = getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable() {
           @Override
           public void run() {
                try {
                    executors.performOnForeground(get(), callback);
                } catch (final ClientException e) {
                    executors.performOnForeground(e, callback);
                }
           }
        });
    }

    public IUserGetManagedAppPoliciesCollectionPage get() throws ClientException {
        final UserGetManagedAppPoliciesCollectionResponse response = send();
        return buildFromResponse(response);
    }


    public IUserGetManagedAppPoliciesCollectionPage buildFromResponse(final UserGetManagedAppPoliciesCollectionResponse response) {
        final IUserGetManagedAppPoliciesCollectionRequestBuilder builder;
        if (response.nextLink != null) {
            builder = new UserGetManagedAppPoliciesCollectionRequestBuilder(response.nextLink, getBaseRequest().getClient(), /* options */ null);
        } else {
            builder = null;
        }
        final IUserGetManagedAppPoliciesCollectionPage page = new UserGetManagedAppPoliciesCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
    public IUserGetManagedAppPoliciesCollectionRequest select(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$select", value));
        return (IUserGetManagedAppPoliciesCollectionRequest)this;
    }

    /**
     * Sets the top value for the request
     *
     * @param value the max number of items to return
     * @return the updated request
     */
    public IUserGetManagedAppPoliciesCollectionRequest top(final int value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$top", value+""));
        return (IUserGetManagedAppPoliciesCollectionRequest)this;
    }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
    public IUserGetManagedAppPoliciesCollectionRequest expand(final String value) {
        addQueryOption(new com.microsoft.graph.options.QueryOption("$expand", value));
        return (IUserGetManagedAppPoliciesCollectionRequest)this;
    }

}
