// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.http.IRequestBuilder;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.models.extensions.WindowsDefenderAdvancedThreatProtectionConfiguration;
import java.util.Arrays;
import java.util.EnumSet;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseRequest;
import com.microsoft.graph.http.HttpMethod;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Windows Defender Advanced Threat Protection Configuration Request.
 */
public class WindowsDefenderAdvancedThreatProtectionConfigurationRequest extends BaseRequest implements IWindowsDefenderAdvancedThreatProtectionConfigurationRequest {
	
    /**
     * The request for the WindowsDefenderAdvancedThreatProtectionConfiguration
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WindowsDefenderAdvancedThreatProtectionConfigurationRequest(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions, WindowsDefenderAdvancedThreatProtectionConfiguration.class);
    }

    /**
     * Gets the WindowsDefenderAdvancedThreatProtectionConfiguration from the service
     *
     * @param callback the callback to be called after success or failure
     */
    public void get(final ICallback<WindowsDefenderAdvancedThreatProtectionConfiguration> callback) {
        send(HttpMethod.GET, callback, null);
    }

    /**
     * Gets the WindowsDefenderAdvancedThreatProtectionConfiguration from the service
     *
     * @return the WindowsDefenderAdvancedThreatProtectionConfiguration from the request
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration get() throws ClientException {
       return send(HttpMethod.GET, null);
    }

    /**
     * Delete this item from the service
     *
     * @param callback the callback when the deletion action has completed
     */
    public void delete(final ICallback<WindowsDefenderAdvancedThreatProtectionConfiguration> callback) {
        send(HttpMethod.DELETE, callback, null);
    }

    /**
     * Delete this item from the service
     *
     * @throws ClientException if there was an exception during the delete operation
     */
    public void delete() throws ClientException {
        send(HttpMethod.DELETE, null);
    }

    /**
     * Patches this WindowsDefenderAdvancedThreatProtectionConfiguration with a source
     *
     * @param sourceWindowsDefenderAdvancedThreatProtectionConfiguration the source object with updates
     * @param callback the callback to be called after success or failure
     */
    public void patch(final WindowsDefenderAdvancedThreatProtectionConfiguration sourceWindowsDefenderAdvancedThreatProtectionConfiguration, final ICallback<WindowsDefenderAdvancedThreatProtectionConfiguration> callback) {
        send(HttpMethod.PATCH, callback, sourceWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Patches this WindowsDefenderAdvancedThreatProtectionConfiguration with a source
     *
     * @param sourceWindowsDefenderAdvancedThreatProtectionConfiguration the source object with updates
     * @return the updated WindowsDefenderAdvancedThreatProtectionConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration patch(final WindowsDefenderAdvancedThreatProtectionConfiguration sourceWindowsDefenderAdvancedThreatProtectionConfiguration) throws ClientException {
        return send(HttpMethod.PATCH, sourceWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Creates a WindowsDefenderAdvancedThreatProtectionConfiguration with a new object
     *
     * @param newWindowsDefenderAdvancedThreatProtectionConfiguration the new object to create
     * @param callback the callback to be called after success or failure
     */
    public void post(final WindowsDefenderAdvancedThreatProtectionConfiguration newWindowsDefenderAdvancedThreatProtectionConfiguration, final ICallback<WindowsDefenderAdvancedThreatProtectionConfiguration> callback) {
        send(HttpMethod.POST, callback, newWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Creates a WindowsDefenderAdvancedThreatProtectionConfiguration with a new object
     *
     * @param newWindowsDefenderAdvancedThreatProtectionConfiguration the new object to create
     * @return the created WindowsDefenderAdvancedThreatProtectionConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration post(final WindowsDefenderAdvancedThreatProtectionConfiguration newWindowsDefenderAdvancedThreatProtectionConfiguration) throws ClientException {
        return send(HttpMethod.POST, newWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Creates a WindowsDefenderAdvancedThreatProtectionConfiguration with a new object
     *
     * @param newWindowsDefenderAdvancedThreatProtectionConfiguration the object to create/update
     * @param callback the callback to be called after success or failure
     */
    public void put(final WindowsDefenderAdvancedThreatProtectionConfiguration newWindowsDefenderAdvancedThreatProtectionConfiguration, final ICallback<WindowsDefenderAdvancedThreatProtectionConfiguration> callback) {
        send(HttpMethod.PUT, callback, newWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Creates a WindowsDefenderAdvancedThreatProtectionConfiguration with a new object
     *
     * @param newWindowsDefenderAdvancedThreatProtectionConfiguration the object to create/update
     * @return the created WindowsDefenderAdvancedThreatProtectionConfiguration
     * @throws ClientException this exception occurs if the request was unable to complete for any reason
     */
    public WindowsDefenderAdvancedThreatProtectionConfiguration put(final WindowsDefenderAdvancedThreatProtectionConfiguration newWindowsDefenderAdvancedThreatProtectionConfiguration) throws ClientException {
        return send(HttpMethod.PUT, newWindowsDefenderAdvancedThreatProtectionConfiguration);
    }

    /**
     * Sets the select clause for the request
     *
     * @param value the select clause
     * @return the updated request
     */
     public IWindowsDefenderAdvancedThreatProtectionConfigurationRequest select(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$select", value));
         return (WindowsDefenderAdvancedThreatProtectionConfigurationRequest)this;
     }

    /**
     * Sets the expand clause for the request
     *
     * @param value the expand clause
     * @return the updated request
     */
     public IWindowsDefenderAdvancedThreatProtectionConfigurationRequest expand(final String value) {
         getQueryOptions().add(new com.microsoft.graph.options.QueryOption("$expand", value));
         return (WindowsDefenderAdvancedThreatProtectionConfigurationRequest)this;
     }

}

