// ------------------------------------------------------------------------------
// Copyright (c) Microsoft Corporation.  All Rights Reserved.  Licensed under the MIT License.  See License in the project root for license information.
// ------------------------------------------------------------------------------

package com.microsoft.graph.requests.extensions;
import com.microsoft.graph.requests.extensions.IWorkbookTableClearFiltersRequest;
import com.microsoft.graph.requests.extensions.WorkbookTableClearFiltersRequest;

import com.microsoft.graph.core.BaseActionRequestBuilder;
import com.microsoft.graph.core.BaseFunctionRequestBuilder;
import com.microsoft.graph.core.IBaseClient;
import com.google.gson.JsonElement;

// **NOTE** This file was generated by a tool and any changes will be overwritten.

/**
 * The class for the Workbook Table Clear Filters Request Builder.
 */
public class WorkbookTableClearFiltersRequestBuilder extends BaseActionRequestBuilder implements IWorkbookTableClearFiltersRequestBuilder {

    /**
     * The request builder for this WorkbookTableClearFilters
     *
     * @param requestUrl     the request URL
     * @param client         the service client
     * @param requestOptions the options for this request
     */
    public WorkbookTableClearFiltersRequestBuilder(final String requestUrl, final IBaseClient client, final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        super(requestUrl, client, requestOptions);
    }

    /**
     * Creates the IWorkbookTableClearFiltersRequest
     *
     * @return the IWorkbookTableClearFiltersRequest instance
     */
    public IWorkbookTableClearFiltersRequest buildRequest() {
        return buildRequest(getOptions());
    }

    /**
     * Creates the IWorkbookTableClearFiltersRequest with specific requestOptions instead of the existing requestOptions
     *
     * @param requestOptions the options for the request
     * @return the IWorkbookTableClearFiltersRequest instance
     */
    public IWorkbookTableClearFiltersRequest buildRequest(final java.util.List<? extends com.microsoft.graph.options.Option> requestOptions) {
        WorkbookTableClearFiltersRequest request = new WorkbookTableClearFiltersRequest(
                getRequestUrl(),
                getClient(),
                requestOptions
        );

        return request;
    }
}
