/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.graph.requests.extensions;

import com.microsoft.graph.concurrency.ICallback;
import com.microsoft.graph.concurrency.IExecutors;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.core.IBaseClient;
import com.microsoft.graph.http.BaseCollectionRequest;
import com.microsoft.graph.models.extensions.DirectoryObject;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionPage;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.DirectoryObjectCollectionResponse;
import com.microsoft.graph.requests.extensions.DirectoryObjectRequestBuilder;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionPage;
import com.microsoft.graph.requests.extensions.IDirectoryObjectCollectionRequest;
import java.util.List;

public class DirectoryObjectCollectionRequest
extends BaseCollectionRequest<DirectoryObjectCollectionResponse, IDirectoryObjectCollectionPage>
implements IDirectoryObjectCollectionRequest {
    public DirectoryObjectCollectionRequest(String requestUrl, IBaseClient client, List<? extends Option> requestOptions) {
        super(requestUrl, client, requestOptions, DirectoryObjectCollectionResponse.class, IDirectoryObjectCollectionPage.class);
    }

    @Override
    public void get(final ICallback<IDirectoryObjectCollectionPage> callback) {
        final IExecutors executors = this.getBaseRequest().getClient().getExecutors();
        executors.performOnBackground(new Runnable(){

            @Override
            public void run() {
                try {
                    executors.performOnForeground(DirectoryObjectCollectionRequest.this.get(), callback);
                }
                catch (ClientException e) {
                    executors.performOnForeground(e, callback);
                }
            }
        });
    }

    @Override
    public IDirectoryObjectCollectionPage get() throws ClientException {
        DirectoryObjectCollectionResponse response = (DirectoryObjectCollectionResponse)this.send();
        return this.buildFromResponse(response);
    }

    @Override
    public void post(DirectoryObject newDirectoryObject, ICallback<DirectoryObject> callback) {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        new DirectoryObjectRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryObject, callback);
    }

    @Override
    public DirectoryObject post(DirectoryObject newDirectoryObject) throws ClientException {
        String requestUrl = this.getBaseRequest().getRequestUrl().toString();
        return new DirectoryObjectRequestBuilder(requestUrl, this.getBaseRequest().getClient(), null).buildRequest(this.getBaseRequest().getHeaders()).post(newDirectoryObject);
    }

    @Override
    public IDirectoryObjectCollectionRequest expand(String value) {
        this.addQueryOption(new QueryOption("$expand", value));
        return this;
    }

    @Override
    public IDirectoryObjectCollectionRequest select(String value) {
        this.addQueryOption(new QueryOption("$select", value));
        return this;
    }

    @Override
    public IDirectoryObjectCollectionRequest top(int value) {
        this.addQueryOption(new QueryOption("$top", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectCollectionRequest skip(int value) {
        this.addQueryOption(new QueryOption("$skip", value + ""));
        return this;
    }

    @Override
    public IDirectoryObjectCollectionRequest skipToken(String skipToken) {
        this.addQueryOption(new QueryOption("$skiptoken", skipToken));
        return this;
    }

    public IDirectoryObjectCollectionPage buildFromResponse(DirectoryObjectCollectionResponse response) {
        DirectoryObjectCollectionRequestBuilder builder = response.nextLink != null ? new DirectoryObjectCollectionRequestBuilder(response.nextLink, this.getBaseRequest().getClient(), null) : null;
        DirectoryObjectCollectionPage page = new DirectoryObjectCollectionPage(response, builder);
        page.setRawObject(response.getSerializer(), response.getRawObject());
        return page;
    }
}

